import numarray.numarraycore as _nc
import numarray.generic as _gen
import numarray.linear_algebra as _la

def _matrixize(result):
    result.__class__ = Matrix
    return result

def array(*args, **keys):
    return _matrixize(_nc.array(*args, **keys))

def fromlist(*args, **keys):
    return _matrixize(_nc.fromlist(*args, **keys))

def fromfile(*args, **keys):
    return _matrixize(_nc.fromfile(*args, **keys))

class Matrix(_nc.NumArray):

    def _reclassify(self, a):
        a.__class__ = self.__class__
        return a
        
    def __mul__(self, other):
        return self._reclassify(_nc.dot(self, other))

    def determinant(self):
        return _la.determinant(self)

    def inverse(self):
        return self._reclassify(_la.inverse(self))

    __repr__ = _gen.NDArray.__repr__


