#!/usr/bin/perl

# This program makes the perl script of SPEL

# check the operating system and if the corresponding executables exist
my $opSys = $^O;
$opSys =~ tr/a-z/A-Z/;
#print $opSys, "\n";
if($opSys eq "LINUX") {
	unless(-f "SPECIFICITY_LINUX_RH_PC") {
		print "SPECIFICITY_LINUX_RH_PC does not exist", "\n";
		exit(1);
	}
	unless(-f "SIMULATION_LINUX_RH_PC") {
		print "SPECIFICITY_LINUX_RH_PC does not exist", "\n";
		exit(1);
	}
	unless(-f "ANCESCON_LINUX_RH_PC") {
		print "SPECIFICITY_LINUX_RH_PC does not exist", "\n";
		exit(1);
	}
	chmod 0755, "SPECIFICITY_LINUX_RH_PC", 'SIMULATION_LINUX_RH_PC', "ANCESCON_LINUX_RH_PC";
	print "Your operating system is LINUX", "\n";
}
elsif($opSys eq "SOLARIS") {
	# get platform name 
	$platform = `uname -p`;
	$platform =~ tr/a-z/A-Z/;
	$platform =~ s/\n//;
	if ($platform eq "I386") {
		$platform = "INTEL";
	}
	unless( ($platform eq 'INTEL') or ($platform eq 'SPARC') ){
		print "Platform not supported: $platform\n";
		print "Supported operating systems and platforms are:\n";
		print "\t LINUX,   SOLARIS INTEL,  SOLARIS SPARC\n";
		exit(1);
	}
	$specificity_file = "SPECIFICITY_SOLARIS_".$platform;
	$simulation_file = "SIMULATION_SOLARIS_".$platform;
	$ancescon_file = "ANCESCON_SOLARIS_".$platform;
	unless(-f $specificity_file) {
		print "$specificity_file does not exist", "\n";
		exit(1);
	}
	unless(-f $simulation_file) {
		print "$simulation_file does not exist", "\n";
		exit(1);
	}
	unless(-f $ancescon_file) {
		print "$ancescon_file does not exist", "\n";
		exit(1);
	}
	chmod 0755, $specificity_file, $simulation_file, $ancescon_file;
	print "Your operating system is SOLARIS and the platform is $platform\n";
}
else {
	unless( ($platform eq 'INTEL') or ($platform eq 'SPARC') ){
		print "Operating system not supported: $opSys\n";
		print "Supported operating systems and platforms are:\n";
		print "\t LINUX,   SOLARIS INTEL,  SOLARIS SPARC\n";
		exit(1);
	}
}
	
# determine current directory
use Cwd;
my $my_dir = getcwd;

# generate SPEL.pl from SPEL.pl_template, changing the directory
open(SPEL_T, "SPEL.pl_template") or die "cannot open SPEL.pl_template";
open(SPEL, ">spel.pl") or die "cannot open SPEL.pl for writing to";
while(<SPEL_T>) {
	if(/^\$command_dir/) {
		$_ = "\$command_dir = \"".$my_dir."\";\n";
	}
	print SPEL $_;
}
close(SPEL_T);
close(SPEL);


print "Finished installing SPEL", "\n";
print "Program spel.pl is generated in current directory\n";

	

