#!/usr/bin/perl

## input: "get_pdbseq_stdout.pl pdbID BIN_PATH_for_pdbcp"
## function: get the atom-based sequences for each chain of the pdb. 
##           Output to the STDOUT.

$pdbid = $ARGV[0];
$BIN_PATH = $ARGV[1];
if (-e "$pdbid.pdb" == 0) {
  `$BIN_PATH/pdbcp $pdbid`;
}
if (-e "$pdbid.pdb" == 0) {
  print STDERR "ERROR: Could not find $pdbid by get_pdbseq_stdout.pl.\n";
  die;
}  
open(PDBIN, "$pdbid.pdb");
@all_pdbin = <PDBIN>;

$start = 1;
$prev_chain = "null";
$prev_resnum = "null";
$bad_chain = "null";
%all_chains = ();

LN: foreach $line (@all_pdbin) {
  last LN if ($line =~ /^ENDMDL/);
  next LN unless ( ($line =~ /^ATOM/ ) || ($line =~ /^HETATM/) );
  next LN unless (substr($line, 12, 4) eq " CA ");
  $chain = substr($line, 21, 1);
  if( $chain eq ' ' ){
	$chain = '_';
  }
  next LN if($chain eq $bad_chain);

  if ($chain ne $prev_chain) {
    if ($start == 1) {
      print STDOUT ">$pdbid\_$chain\n";

      $prev_chain = $chain;
      $all_chains{$chain} = 1;
      $start = 0;
    }
    else {
      foreach $ch (keys %all_chains){
        if($chain eq $ch ){
	  $bad_chain = $chain;
          $prev_chain = $chain;
          next LN;
        }
      }

      print STDOUT "\n";
      print STDOUT ">$pdbid\_$chain\n";

      $all_chains{$chain} = 1;
      $prev_chain = $chain;
    }
  }

  $resnum = substr($line, 22, 6);
  if ($prev_resnum eq $resnum) {
    next LN if (substr($line, 56, 4) ne "1.00");
  }  
  $prev_resnum = $resnum;
  $aa = substr($line, 17, 3);
  if ($aa eq "VAL") {print STDOUT "V"; }
  elsif ($aa eq "LEU") {print STDOUT "L"; }
  elsif ($aa eq "PRO") {print STDOUT "P"; }
  elsif ($aa eq "GLY") {print STDOUT "G"; }
  elsif ($aa eq "SER") {print STDOUT "S"; }
  elsif ($aa eq "ASN") {print STDOUT "N"; }
  elsif ($aa eq "GLN") {print STDOUT "Q"; }
  elsif ($aa eq "ASP") {print STDOUT "D"; }
  elsif ($aa eq "GLU") {print STDOUT "E"; }
  elsif ($aa eq "MET") {print STDOUT "M"; }
  elsif ($aa eq "MSE") {print STDOUT "M"; }
  elsif ($aa eq "TRP") {print STDOUT "W"; }
  elsif ($aa eq "PHE") {print STDOUT "F"; }
  elsif ($aa eq "ILE") {print STDOUT "I"; }
  elsif ($aa eq "THR") {print STDOUT "T"; }
  elsif ($aa eq "CYS") {print STDOUT "C"; }
  elsif ($aa eq "TYR") {print STDOUT "Y"; }
  elsif ($aa eq "HIS") {print STDOUT "H"; }
  elsif ($aa eq "LYS") {print STDOUT "K"; }
  elsif ($aa eq "ARG") {print STDOUT "R"; }
  elsif ($aa eq "ALA") {print STDOUT "A"; }
  else {print STDOUT "X"; }
}
print STDOUT "\n";

close(PDBIN);
`rm $pdbid.pdb`;
