#! /usr/bin/perl -w
# input fasta_seqs_file is usually the SCOP seqs file downloaded from Astral.

if( $#ARGV != 0){
	print STDERR "Usage: mk_rps_lib.pl database_name(output)\n";
	exit;
}

if ($ARGV[0] =~ /\//) {
  @ar = split/\//, $ARGV[0];
  $dirname = "";
  for ($i=0; $i!=($#ar); $i++) { $dirname .= "$ar[$i]"; }
  chdir "$dirname";
  $rpsdb = $ar[$#ar];
}
else { $rpsdb = $ARGV[0]; }

system "makemat -P $rpsdb -S 1 ";
system "copymat -P $rpsdb -r T ";
system "formatdb -i $rpsdb -o T";

`tar cvzf ceq.tgz *.ceq`;
`tar cvzf chk.tgz *.chk`;
`tar cvzf mtx.tgz *.mtx`;
`rm -f *.ceq`;
`rm -f *.chk`;
`rm -f *.mtx`;
