#! /usr/bin/perl -w
# input fasta_seqs_file is usually the SCOP seqs file downloaded from Astral.

if( $#ARGV != 2){
	print STDERR "Usage: mk_psi_profile.pl fasta_seqs_file(input)  database_name(output) nr_path\n";
	exit;
}
open( IN, "$ARGV[0]" ) || die "ERROR: can't open input file $ARGV[0]\n";

open( PN, ">$ARGV[1].pn") || die "ERROR: can't open output file $ARGV[1].pn\n";
open( SN, ">$ARGV[1].sn") || die "ERROR: can't open output file $ARGV[1].sn\n";

system "cp ~/.ncbirc .";
$first = 1;
while(<IN>){
  chomp;
  if( /^>/ ){
    if( !$first ){
      print SEQ "\n";
      close( SEQ );
      system "blastpgp -i $id.ceq -d $ARGV[2] -o $id.br -m 6 -e 0.005 -j 5 -h 0.005 -C $id.chk -a 8";
    }else{
	$first = 0;
    }

    @tmp = split / /, $';
    $id = $tmp[0];
    print SN "$id.ceq\n";
    print PN "$id.chk\n";

    open( SEQ, ">$id.ceq" ) || die "ERROR: can't open output file $id.ceq\n";
    print SEQ "$_\n";
  }else{
    print SEQ "$_";
  }
}
print SEQ "\n";
close SEQ;
system "blastpgp -i $id.ceq -d $ARGV[2] -o $id.br -m 6 -e 0.005 -j 5 -h 0.005 -C $id.chk -a 8";

    
      
	
 
