#!/usr/bin/perl

$path_bin = @ARGV[0];

opendir(DIR, ".");
@allfiles = readdir DIR;
foreach $file (@allfiles) {
  next unless ($file =~ /\.ent/);
  open(IN, "$file");
  @in = <IN>;
  $str = substr($file, 0, 7);
  open(OUT, ">$str.tmp");
  $ct = 0;
  foreach $line (@in) {
    if ($line =~ /MSE/ && ($line =~ /^HETATM/ | $line =~ /^ATOM/)) {
      $str1 = substr($line, 6, 11);
      $str2 = substr($line, -61);
      print OUT "ATOM  $str1\MET$str2";
      $ct++;
    }
    else { print OUT "$line"; }
  }
  close(IN);
  close(OUT);
  if ($ct == 0) { `rm $str.tmp`; next; }
  `mv $str.tmp $str.ent`;
}
closedir(DIR);

`ls -1 *.ent > libdomains.list`;
open(IN, "libdomains.list");
@in = <IN>;
open(OUT, ">scoplib2dali");
$start=1004;
foreach $line (@in) {
  chomp $line;
  $start++; if ($start == 1000 | $start == 8000 | $start == 9000 | $start == 9950) { $start++; }
  $pdbid = $line;
  print OUT "$pdbid $start\n";
}
close(OUT);

$start=1004;
open(LIST5N, ">libdatlist");
foreach $line (@in) {
  chomp $line;
  $pdbid = $line;
  $start++; if ($start == 1000 | $start == 8000 | $start == 9000 | $start == 9950) { $start++; }
  if (-e "dali.lock") {`rm dali.lock`;}
  system ("$path_bin/DaliLite -readbrk ./$pdbid $start");
  $ls = `ls -1 core* | wc -l`; chomp $ls;
  if ($ls != 0) { `rm core* dali.lock`; }
  opendir(DIR, ".");
  @allfiles = readdir DIR;
  $ct = 0;
  FL: foreach $file (@allfiles) {
    next FL unless ($file =~ /\.dat/);
    $str = substr($file, 0, 4);
    if ($str == $start) {
      $ct += 1;
      $newstr = substr($file, 0, 5);
    }
  }
  if (substr($pdbid, 5, 1) eq ".") { `rm $start*`; }
  else {
    if ($ct == 1) { print LIST5N "$newstr\n"; }
    else { `rm $start*`; }
  }
  closedir(DIR);
}
close(LIST5N);
close(IN);

open(IN1, "scoplib2dali");
@all_in1 = <IN1>;
open(IN2, "libdatlist");
@all_in2 = <IN2>;
open(OUT2, ">scoplib2dali_5N");
LN1: foreach $line1 (@all_in1) {
  chomp $line1;
  @ar1 = split/ /, $line1;
  LN2: foreach $line2 (@all_in2) {
    chomp $line2;
    next LN2 unless (substr($line2, 0, 4) eq $ar1[1]);
    print OUT2 "$ar1[0] $line2\n";
    last LN2;
  }
}
close(IN1);
close(IN2);
close(OUT2);

`cat scoplib2dali_5N | cut -c1-7 > pairslist`;

`tar cvf tarscoplibpdb.tar *.ent`;
`bzip2 tarscoplibpdb.tar`;
`tar cvf tarscoplibdssp.tar *.dssp`;
`bzip2 tarscoplibdssp.tar`;
`tar cvf tarscoplibdat.tar *.dat`;
`bzip2 tarscoplibdat.tar`;

`mkdir datfiles`;
`mv *.dssp datfiles`;
`mv *.dat datfiles`;




#for making step9 library info...

chdir "datfiles";
open(LIST1, "../libdomains.list");
@list1 = <LIST1>;
open(LIST2, "../scoplib2dali_5N");
@list2 = <LIST2>;

open(OUT, ">../zratinfo");

`cp $path_bin/DaliLite .`;
foreach $line1 (@list1) {
  $dom = substr($line1, 0, 7);
  $dat = "";
  foreach $line2 (@list2) {
    next unless (substr($line2, 0, 7) eq $dom);
    chomp $line2;
    @ar1 = split/\s/, $line2;
    $dat = "$ar1[1]";
    last;
  }
  open(IN, "../$dom.ent");
  @in = <IN>;
  $ct = 0;
  foreach $iline (@in) { next unless (substr($iline, 13, 2) eq "CA"); $ct++; }
  close(IN);
  $selfz = "error";
  if ($ct > 0 && $ct < 150 && $dat ne "") {
    `./DaliLite -align $dat $dat`;
    if (-e "dali.lock" == 1) { `rm dali.lock`; }
    if (-e "$dat.dccp" == 1) { $selfz = SUB_get_maxz ( "$dat.dccp" ); }
    `rm $dat.dccp`;
  }
  print OUT "$dom.ent\t$ct\t";
  if ($selfz eq "error") { print OUT "X\n"; }
  else { print OUT "$selfz\n"; }
}
close(OUT);
close(LIST1);
close(LIST2);


##########
#
# subroutine use: SUB_get_maxz ( $dccpfile )

sub SUB_get_maxz {
  $dccpfile = @_[0];
  open(IN, "$dccpfile");
  @in = <IN>;
  $max = -1;
  foreach $line (@in) {
    next unless ($line =~ /^ DCCP/);
    next unless (substr($line, 69, 5) eq substr($line, 75, 5));
    $thisz = substr($line, 30, 4); $thisz =~ s/ //g;
    if ($thisz > $max) { $max = $thisz; }
  }
  close(IN);
  if ($max == -1) { return "error"; }
  else { return "$max"; }
}
